<?php Yii::import("webroot.themes.press.ThemeFunctions"); ?>
<div class="page-navigation clearfix">
    <div class="pull-left">
        <?php if(EpaperSettings::i()->enable_bookmarks){ ?>
        <?php $bookmarks = EpaperBookmark::model()->getBookmarksByEdition($edition_model->ed_id); ?>
        <?php if (count($bookmarks) > 0) { ?>
            <div class="btn-group bookmarklist  hidden-sm hidden-xs">
                <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class='glyphicon glyphicon-bookmark'></span> <?php echo Yii::t("theme_press", "Titles In This Issue") ?> <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <?php   
                    foreach ($bookmarks as $m) {
                        $page_index = EpaperPage::model()->getPageIndex($current_page_model->ed_id, $m["pg_id"]);

                        unset($urlparam);

                        $urlparam["id"] = $edition_model->ed_id;
                        $urlparam["alias"] = $edition_model->ed_alias;
                        if ($page_index > 1) {
                            $urlparam["page"] = $page_index;
                        }
                        if ($m["sp_id"] > 0) {
                            $urlparam["spid"] = $m["sp_id"];
                            $urlparam["spalias"] = $m["sp_alias"];
                        }
                        ?>
                        <li>
                            <a href="<?php echo $this->createUrl("//epaper/default/show", $urlparam); ?>"><?php echo $m["bkm_title"] ?></a>
                        </li>
                    <?php } ?>
                </ul>
            </div> &nbsp;
        <?php } ?>
        <?php } ?>
    </div>

    <div class="pull-left hidden-sm hidden-xs">
        <?php  $this->widget('CLinkPager', array(
            'pages' => $pagination,
            'cssFile' => false,
            'header' => false,
            'maxButtonCount' => 1,
            'nextPageLabel' => '&gt;&gt;',
            'prevPageLabel' => '&lt;&lt;',
            'hiddenPageCssClass' => 'disabled',
            'selectedPageCssClass' => 'active',
            'htmlOptions' => array("class" => "pagination")
        ));
        ?>
    </div>
    <div class="pull-left" style="margin-left:10px;">
        <div class="form-inline form-horizontal"> 
            <select name="ddlistPage" id="ddlistPage" class="form-control">
                <?php
                $n = 1;
                foreach ($page_models[$spid] as $pm) {
                    if ($n == $page) {
                        echo "<option selected value='$n'>" . Yii::t("theme_press", "Page") . " $n</option>";
                    } else {
                        echo "<option value='$n'>" . Yii::t("theme_press", "Page") . " $n</option>";
                    }
                    $n++;
                }
                ?>
            </select>
            <script>
               
                $(document).on("change", "#ddlistPage", function () {
                    if(spid === 0){
                        var url = "<?php echo $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $alias, "page" => "T_Page")); ?>";
                        url = url.replace("T_Page", $(this).val());
                    } else {
                        var url = "<?php echo $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $alias, "spid" => "T_Spid", "spalias" => "T_Spalias", "page" => "T_Page")); ?>";
                        url = url.replace("T_Page", $(this).val());
                        url = url.replace("T_Spid", spid);
                        url = url.replace("T_Spalias", spalias);
                    }
                    <?php if (Press_ThemeSettings::i()->enable_ajax) { ?>
                        loadPage(url);
                    <?php } else { ?>
                        window.location = url;
                    <?php } ?> 
                });
            </script>
     
            <a href="#" id="linkbtnThumb" class="btn btn-default hidden-xs hidden-sm"><span class='glyphicon glyphicon-th-large'></span></a>
            <?php
            $this->widget('AtAGlanceWidget', array(
                'pageModels' => $page_models[$spid],
                'spid'=>$spid,
                'spalias'=>$spalias,
                'editionModel' => $edition_model,
                'button' => '#linkbtnThumb'
            ));
            ?>

            <?php if (trim($edition_model->ed_pdf) != "" || trim($current_page_model->pg_pdf) != "") { ?>
                <div class="btn-group">
                    <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <span class='glyphicon glyphicon-download'></span> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu">
                        <?php if (trim($edition_model->ed_pdf) != "") { ?>
                            <li>
                                <a href="<?php echo EpaperHelpers::i()->getPdfLink($edition_model); ?>"><?php echo Yii::t("theme_press", "Full PDF"); ?></a>
                            </li>
                        <?php } ?>
                        <?php if (trim($current_page_model->pg_pdf) != "") { ?> 
                            <li>
                                <a href="<?php echo EpaperHelpers::i()->getPdfLink($current_page_model); ?>"><?php echo Yii::t("theme_press", "Current Page PDF"); ?></a>
                            </li>
                        <?php } ?>  
                </div>
            <?php } ?>  


        </div>
    </div>

    <div class="pull-right">
        <?php
        if(Press_ThemeSettings::i()->archive_type != Press_ThemeSettings::ARC_NONE){  
            $this->widget('CalenderWidget', array(
                "catId" => $edition_model->cat_id,
                "format" => CalenderWidget::FORMAT_WITHTEXT,
                "btnClass" => "btn btn-default",
                "currentDate" => Helpers::i()->formatDate($edition_model->ed_date, "d-M-Y")
            ));
        }
        ?>
    </div>
</div>
